@extends('admin.layouts.master')
@section('title','Create a new user')
@section('maincontent')
<?php
$data['heading'] = 'Create A New User';
$data['title'] = 'User';
$data['title1'] = 'Create A New User';
?>
@include('admin.layouts.topbar',$data)
<div class="contentbar dashboard-card">
  @if ($errors->any())
  <div class="alert alert-danger" role="alert">
    @foreach($errors->all() as $error)
    <p>{{ $error}}<button type="button" class="close" data-dismiss="alert" aria-label="Close" title="{{ __('Close') }}">
        <span aria-hidden="true" style="color:red;">&times;</span></button></p>
    @endforeach
  </div>
  @endif
  <div class="row">
    <div class="col-lg-12">
      <div class="card dashboard-card m-b-30">
        <div class="card-header">
          <h5 class="box-tittle">{{ __('Add') }} {{ __('User') }}</h5>
          <div>
            <div class="widgetbar">
              <a href="{{route('user.index')}}" class="float-right btn btn-primary-rgba mr-2" title="{{ __('Back') }}"><i
                  class="feather icon-arrow-left mr-2"></i>{{ __('Back') }}</a> </div>
          </div>
        </div>
        <div class="card-body">
          <form action="{{ route('user.store') }}" method="POST" enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="bg-info-rgba p-4 mb-4">
              <h4 class="pb-4">{{ __('Personal Details') }}</h4>
              <div class="row">
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="fname">
                      {{ __('First Name') }}:<sup class="text-danger">*</sup>
                    </label>
                    <input value="{{ old('fname') }}" autofocus required name="fname" type="text" class="form-control"
                      placeholder="{{ __('Please') }} {{ __('Enter First Name') }}" />
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="lname">
                      {{ __('Last Name') }}:<sup class="text-danger">*</sup>
                    </label>
                    <input value="{{ old('lname')}}" required name="lname" type="text" class="form-control"
                      placeholder="{{ __('Please') }} {{ __('Enter Last Name') }}" />
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="mobile">{{ __('Email') }}: <sup
                        class="text-danger">*</sup></label>
                    <input value="{{ old('email')}}" required type="email" name="email"
                      placeholder=" {{ __('Please') }} {{ __('Enter Email') }}"
                      class="form-control">
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="mobile">{{ __('Mobile') }}: <sup class="text-danger">*</sup></label>
                    <input value="{{ old('mobile')}}" required type="text" name="mobile"
                      placeholder="{{ __('Please') }} {{ __('Enter Mobile') }}"
                      class="form-control">
                  </div>
                </div>                
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="role">{{ __('Select User Role') }}: <sup
                        class="text-danger">*</sup></label>
                    <select class="form-control select2" name="role" required>
                      <option value="none" selected disabled hidden>
                        {{ __('Please') }} {{ __('Select an Option') }}
                      </option>
                      @foreach($roles as $role)
                      <option {{ app('request')->input('type') == $role->name ? "selected" : "" }} value="{{ $role->name }}">{{ $role->name }}</option>
                    @endforeach
                    </select>
                  </div>
                </div>                
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="mobile">{{ __('Password') }}: <sup
                        class="text-danger">*</sup> </label>
                    <input required type="password" name="password"
                      placeholder="{{ __('Please') }} {{ __('Enter Password') }}"
                      class="form-control">
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group">
                    <label class="text-dark" for="exampleInputDetails">{{ __('Detail') }}:</label>
                    <textarea id="detail" name="detail" rows="1" class="form-control"
                      placeholder="{{ __('Please') }} {{ __('Enter Detail') }}"></textarea>
                  </div>
                </div>
              </div>
            </div>
            <div class="bg-info-rgba p-4 mb-4">
              <h4 class="pb-4">{{ __('Address') }}</h4>
              <div class="row">
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="exampleInputDetails">{{ __('Address') }}:</label>
                    <textarea name="address" rows="1" class="form-control"
                      placeholder="{{ __('Please Enter Address') }} "></textarea>
                  </div>                
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="country_id">{{ __('Country') }}: </label>
                    <select name="country_id" id="country_id" class="form-control select2">
                      <option value="">{{ __('Select Country') }}</option>
                      @foreach($countries as $country)
                        <option value="{{ $country->country_id }}">{{ $country->nicename }}</option>
                      @endforeach
                    </select>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="state_id">{{ __('State') }}: </label>
                    <select name="state_id" id="state_id" class="form-control select2">
                      <option value="">{{ __('Select State') }}</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="city_id">{{ __('City') }}: </label>
                    <select name="city_id" id="city_id" class="form-control select2">
                      <option value="">{{ __('Select City') }}</option>
                    </select>
                  </div>
                </div>

                <div class="col-md-2">
                  <div class="form-group">
                    <label class="text-dark" for="pin_code">{{ __('Pincode') }}:</sup></label>
                    <input value="{{ old('pin_code')}}" placeholder="{{ __('Please Enter Pincode') }}"
                      type="text" name="pin_code" class="form-control">
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="exampleInputSlug">{{ __('Image') }}: </label>
                    <small class="text-muted"><i class="fa fa-question-circle"></i>
                      {{ __('Recommended size') }} (410 x 410PX)</small>
                    <div class="input-group mb-3">
                      <div class="input-group-prepend">
                        <span class="input-group-text" id="inputGroupFileAddon01">{{ __('Upload') }}</span>
                      </div>
                      <div class="custom-file">
                        <input accept="image/*" type="file" name="user_img" class="custom-file-input" id="user_img_one" aria-describedby="inputGroupFileAddon01" onchange="readURL(this);">
                        <label class="custom-file-label" for="inputGroupFile01">{{ __('Choose file') }}</label>
                      </div>
                    </div>
                    <div class="thumbnail-img-block mb-3">
                      <img src="{{ url('images/user_img/user.jpg')}}" id="user_img" class="img-fluid" alt="{{ __('user')}}">
                    </div>   
                  </div>
                </div>
              </div>
            </div>
            <div class="bg-info-rgba p-4 mb-4">
              <h4 class="pb-4">{{ __('Social Profile') }}</h4>
              <div class="row">
                  <div class="col-md-3">
                    <div class="form-group">
                      <label class="text-dark" for="fb_url">
                        {{ __('Facebook URL') }}:
                      </label>
                      <input autofocus name="fb_url" type="text" class="form-control" placeholder="https://facebook.com/" />
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label class="text-dark" for="youtube_url">
                        {{ __('YouTube URL') }}:
                      </label>
                      <input autofocus name="youtube_url" type="text" class="form-control" placeholder="https://youtube.com/" />
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label class="text-dark" for="twitter_url">
                        {{ __('Twitter URL') }}:
                      </label>
                      <input autofocus name="twitter_url" type="text" class="form-control" placeholder="https://twitter.com/" />
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label class="text-dark" for="linkedin_url">
                        {{ __('LinkedIn URL') }}:
                      </label>
                      <input autofocus name="linkedin_url" type="text" class="form-control" placeholder="https://linkedin.com/" />
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-lg-12">
                <div class="form-group px-4">
                  <label for="exampleInputDetails">{{ __('Status') }}</label><br>
                  <input id="status_toggle" type="checkbox" class="custom_toggle" name="status" checked />
                </div>
              </div>
            </div>
            <div class="form-group p-4">
              <button type="reset" class="btn btn-danger-rgba" title="{{ __('Reset') }}"><i class="fa fa-ban"></i> {{ __('Reset') }}</button>
              <button type="submit" class="btn btn-primary-rgba" title=" {{ __('Create') }}"><i class="fa fa-check-circle"></i>
                {{ __('Create') }}</button>
            </div>
            <div class="clear-both"></div>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
@endsection
@section('script')
<script>
  (function ($) {
    "use strict";

    $('#married_status').change(function () {

      if ($(this).val() == 'Married') {
        $('#doaboxxx').show();
      } else {
        $('#doaboxxx').hide();
      }
    });

    $(function () {
      $("#dob,#doa").datepicker({
        changeYear: true,
        yearRange: "-100:+0",
        dateFormat: 'yy/mm/dd',
      });
    });
    $(function () {

      $('#upload_id').change(function () {
        var up = $('#grand').empty();
        var cat_id = $(this).val();
        if (cat_id) {
          $.ajax({
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: "GET",
            url: @json(url('country/gcity')),
            data: {
              catId: cat_id
            },
            success: function (data) {
              console.log(data);
              up.append('<option value="0">Please Choose</option>');
              $.each(data, function (id, title) {
                up.append($('<option>', {
                  value: id,
                  text: title
                }));
              });
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
              console.log(XMLHttpRequest);
            }
          });
        }
      });
    });
  })(jQuery);
</script>
<script>
  // Add this to your script section
$(document).ready(function() {
    $('#country_id').on('change', function() {
        var countryId = $(this).val();
        if(countryId) {
            $.ajax({
                url: '{{ route("get.states") }}',
                type: 'GET',
                data: { country_id: countryId },
                success: function(data) {
                    $('#state_id').empty();
                    $('#city_id').empty();
                    $('#state_id').append('<option value="">Select State</option>');
                    $('#city_id').append('<option value="">Select City</option>');
                    
                    $.each(data, function(key, value) {
                        $('#state_id').append('<option value="'+ value.state_id +'">'+ value.name +'</option>');
                    });
                }
            });
        } else {
            $('#state_id').empty();
            $('#city_id').empty();
            $('#state_id').append('<option value="">Select State</option>');
            $('#city_id').append('<option value="">Select City</option>');
        }
    });

    $('#state_id').on('change', function() {
        var stateId = $(this).val();
        if(stateId) {
            $.ajax({
                url: '{{ route("get.cities") }}',
                type: 'GET',
                data: { state_id: stateId },
                success: function(data) {
                    $('#city_id').empty();
                    $('#city_id').append('<option value="">Select City</option>');
                    
                    $.each(data, function(key, value) {
                        $('#city_id').append('<option value="'+ value.id +'">'+ value.name +'</option>');
                    });
                }
            });
        } else {
            $('#city_id').empty();
            $('#city_id').append('<option value="">Select City</option>');
        }
    });
});
</script>

@endsection